package DAO;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

import ClassesJava.Lieu;
import ClassesJava.Personne;
import ClassesJava.Profil;


public class ProfilDAO {

	/**
	 * Parametres de connexion  la base de donnes oracle URL, LOGIN et PASSWORD
	 * sont des constantes
	 */
	final static String URL = "jdbc:oracle:thin:@localhost:1521:xe";
	final static String LOGIN = "BDD5"; 
	final static String PASSWORD = "BDD5";
	
	public ProfilDAO() {
	
	//Chargement du pilote de bases de donnes
	
	try {
		Class.forName("oracle.jdbc.OracleDriver");
			
	}catch (ClassNotFoundException e) {
			
		System.err.println("Impossible de charger le pilote de BDD, ne pas oublier d'importer le fichier .jar dans le projet");
		}
	}

	/**
	 * Permet d'ajouter une personne dans la table personne Le mode est auto-commit
	 * donc par dfaut chaque insertion est valide
	 * 
	 * @param personne
	 *            la personne ajouter
	 * @return 
	 * @return retourne un message de confirmation d'ajout
	 */
	public int  Creer_profil(Profil profil) {
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// Prparation de l'instruction SQL: chaque "?" reprsente une valeur
			//  communiquer dans l'insertion
			// Les getters permettent de rcuperer les valeurs des attributs
			// souhaits
				ps = connexion.prepareStatement("INSERT INTO PROFIL (IDPROFIL, TITRE_PROFIL, PROFIL_OPENH, PROFIL_CLOSEH, PROFIL_IDLIEUX) VALUES (PROFIL_SEQUENCE.NEXTVAL, ?, ?, ?, ?)");
				ps.setString(1, profil.getTitre_profil());
				ps.setTime(2, profil.getHouverture());
				ps.setTime(3, profil.getHfermerture());
				ps.setInt(4, profil.getIdLieux());

				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
	}
	
	
	public int Supprimer_profil(Profil profil) {
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// 
			// 
			// 
			// 
				ps = connexion.prepareStatement("DELETE FROM PROFIL WHERE TITRE_PROFIL= ?" );		
				
				ps.setString(1, profil.getTitre_profil());

				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
	}
	
	public Profil getProfil(String titre_profil) {

		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		Profil retour = null;

		// connexion à la base de données
		try {

			con = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			ps = con.prepareStatement("SELECT * FROM PROFIL WHERE TITRE_PROFIL = ?");
			ps.setString(1, titre_profil);

			// on exécute la requête
			// rs contient un pointeur situé juste avant la première ligne
			// retournée
			rs = ps.executeQuery();
			// passe à la première (et unique) ligne retournée
			if (rs.next())
 
				retour = new Profil(rs.getString("TITRE_PROFIL"),
						rs.getTime("PROFIL_OPENH"),
						rs.getTime("PROFIL_CLOSEH"), rs.getInt("PROFIL_IDLIEUX"));

		} catch (Exception ee) {
			
			ee.printStackTrace();

		} finally {
			// fermeture du ResultSet, du PreparedStatement et de la Connexion
			try {
				if (rs != null)
					rs.close();
			} catch (Exception ignore) {
			}
			try {
				if (ps != null)
					ps.close();
			} catch (Exception ignore) {
			}
			try {
				if (con != null)
					con.close();
			} catch (Exception ignore) {
			}
		}
		return retour;

	}
	
	public int get_Id_Profil(String titre_profil) {

		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		int retour = 0;

		// connexion à la base de données
		try {

			con = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			ps = con.prepareStatement("SELECT IDPROFIL FROM PROFIL WHERE TITRE_PROFIL = ?");
			ps.setString(1, titre_profil);

			// on exécute la requête
			// rs contient un pointeur situé juste avant la première ligne
			// retournée
			rs = ps.executeQuery();
			// passe à la première (et unique) ligne retournée
			if (rs.next())
				retour = rs.getInt("IDPROFIL");

		} catch (Exception ee) {
			
			ee.printStackTrace();
			
		} finally {
			// fermeture du ResultSet, du PreparedStatement et de la Connexion
			try {
				if (rs != null)
					rs.close();
			} catch (Exception ignore) {
			}
			try {
				if (ps != null)
					ps.close();
			} catch (Exception ignore) {
			}
			try {
				if (con != null)
					con.close();
			} catch (Exception ignore) {
			}
		}
		return retour;

	}

	public int Modifier_profil(Profil profil, int idlieu) {
		
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// Prparation de l'instruction SQL: chaque "?" reprsente une valeur
			//  communiquer dans l'insertion
			// Les getters permettent de rcuperer les valeurs des attributs
			// souhaits
				ps = connexion.prepareStatement("UPDATE PROFIL SET TITRE_PROFIL = ?, PROFIL_OPENH = ?, PROFIL_CLOSEH = ?, PROFIL_IDLIEUX = ? WHERE PROFIL_IDLIEUX = ?");
				ps.setString(1, profil.getTitre_profil());
				ps.setTime(2, profil.getHouverture());
				ps.setTime(3, profil.getHfermerture());
				ps.setInt(4, idlieu);
				ps.setInt(5,  profil.getIdLieux());
				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
	}

  
	// main permettant de tester la classe
	public static void main(String[] args) throws SQLException {

		ProfilDAO profilDAO = new ProfilDAO();
		
		Profil profil;
		// test de la méthode ajouter
		
		Time Otime = new Time(8,11,00);
		Time Ctime = new Time(10,00,00);
	
		//Profil a1 = new Profil("Etudiant", Otime, Ctime, 1);
		
		//int ins = profilDAO.Creer_profil(a1);
		
		//int sup = profilDAO.Supprimer_profil(a1);
		
		profil = profilDAO.getProfil("Etudiant");
		
		System.out.println(profil.afficher());
		
		//int test = personneDAO.supprimer_personne(a2);
		//System.out.println(ins + " lieu cr");
		
		
	}
	
}
